<?php
/**
 * Anonymous Make Purchase
 *
 * @package     AutomatorWP\Integrations\SureCart\Triggers\Anonymous_Make_Purchase
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_SureCart_Anonymous_Make_Purchase extends AutomatorWP_Integration_Trigger {

    public $integration = 'surecart';
    public $trigger = 'surecart_anonymous_make_purchase';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'anonymous'         => true,
            'label'             => __( 'Guest makes a purchase', 'automatorwp-pro' ),
            'select_option'     => __( 'Guest makes a <strong>purchase</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Product title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'Guest makes a purchase %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'Guest makes a purchase', 'automatorwp-pro' ),
            'action'            => 'surecart/purchase_created',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array     $purchase
     * 
     */
    public function listener( $purchase ) {
        
        $user_id = get_current_user_id();

        // Bail if user is not logged
        if ($user_id !== 0) {
            return;
        }

        // Trigger user product purchased
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'order_id'      => $purchase->initial_order,
            'product_id'    => $purchase->product,
        ) );
       
    }

}

new AutomatorWP_SureCart_Anonymous_Make_Purchase();